/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.soap;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class VWSOAPRouterURL
implements Serializable {
    private static final long serialVersionUID = 464L;
    private static final String INTERNALCONTENTS = "P8BPM5.0-dts936304";
    private String routerName = "vwrouter";
    private String serverURL = null;
    private String JSESSIONID = null;

    public VWSOAPRouterURL(String url) throws MalformedURLException {
        URL soapURL = new URL(url);
        this.serverURL = soapURL.getProtocol() + "://" + soapURL.getHost() + ":" + soapURL.getPort() + soapURL.getPath();
        if (this.serverURL.indexOf("vwsoaprouter") == -1) {
            throw new MalformedURLException();
        }
        String sQuery = soapURL.getQuery();
        if (sQuery != null) {
            int semicolon = sQuery.indexOf(59);
            if (semicolon == -1) {
                this.routerName = sQuery;
            } else {
                this.routerName = sQuery.substring(0, semicolon);
                int x = url.indexOf(this.routerName);
                if (x >= 0) {
                    this.JSESSIONID = url.substring((x += this.routerName.length()) + 1);
                }
            }
        }
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getRouterName() {
        return this.routerName;
    }

    public String toString() {
        return this.serverURL + "?" + this.routerName + (this.JSESSIONID == null ? "" : ";" + this.JSESSIONID);
    }

    public String getJSESSIONID() {
        return this.JSESSIONID;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"http://ccv01122.usca.ibm.com:9080/WorkplaceXT/vwsoaprouter?PELoanRegion;mbox=PC#1287174089928-264748.19#1288400736|session#1287191066662-490351#1287192996|check#true#1287191196; IBM_W3SSO_ACCESS=w3.ibm.com; bn_search=true; UnicaNIODID=DeZPkZ5Kh1J-WosgzRL; ibmSurvey=1302727874514; bn_u=6923241490062075152; JSESSIONID=0000v_NRHwsrtZX-6BXRl5OWIKo:-1; WorkplaceXTBaseUrl=http://ccv01122.usca.ibm.com:9080/WorkplaceXT; LtpaToken2=QB4bREviz8qZcteH/eewPnpyU8IY0hs+Z2NerDGvq2vOpH3YIa6yfYHelH+ypzvSxC2F8eGezLU5kNnW3N7fSzrHvNzBatP69H10zbhDBZPmMIe9tRaSCaA7LiUw7+8LfOFpg0aBe3wLkuvKNCnP88R99je9ibX36Iy1PGfx3tEYytypItKZuULxETi0qpQr8rUYfiH/wP6FDPBs3FAV4aP+x8lAW8ADRwmxVDzMw7e+O4MhKer37oUquZc3SjsNpH2gY36K9/jExR7IaP5gTY5pfLhU8ZuqTeAIfYwNhcecwMaRNsNqr2tZnN1Z1wBUt0ypPJAqxjhWXtiafsD86SSL6918z7z9llX0K+f4MoZfnmB38B1kcaw1dI4f3yK3HuBtqLTBdDdby8pltIA2XX90MAiKEwrY5NLtx9MzOJowTNnb9a10zBa6OVuCntQPlCYbET4VJfW6pOf9eP96dcgUgvLKuX45bGnlYI0ESjahe8tqwnlB376nNYpQGmkIjaa4WB/jc/ds6hCxZbZ8itJUR39malaPFrIvIUMT9udp2oeIS8idbfAc1NTm+KbOa//eIPcCbg1VNoVPaJj8XRubHy+Y60B1FhiTcuJjedrSbcBQZN1UkBeB0tHWguuI50RvRYX6VAGkfIYPrCkJsg==", "http://localhost:7001/Workplace/vwsoaprouter?bootstrapCEURI:t3://hqbmp44:7001/FileNet/Engine?vwrouter", null};
        }
        for (int i = 0; i < args.length; ++i) {
            try {
                if (args[i] == null) continue;
                VWSOAPRouterURL r = new VWSOAPRouterURL(args[i]);
                System.out.println("r.getRouterName = " + r.getRouterName());
                System.out.println("r.getJSESSIONID = " + r.getJSESSIONID());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

